<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Examination</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 50px auto;
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
        }

        .dashboard-box {
            background-color: white;
            border-radius: 12px;
            padding: 30px 20px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .dashboard-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }

        .dashboard-box i {
            font-size: 36px;
            margin-bottom: 15px;
            color: #007bff;
        }

        .dashboard-box span {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>

@include('admin.navbar')

@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

<form action="{{url('saveupdate-course')}}" method="POST">@csrf

<div class="dashboard-container">
    <div class="dashboard-list">

        <hr>
        <h5>Create Course Information</h5>
        <hr>


        <div class="mb-3">
          <label for="coursename" class="form-label">Course Name</label>
          <input type="text" class="form-control" id="coursename" name="coursename" placeholder="Course Name" value="{{$recordsdata->name}}">
        </div>
        <div class="mb-3">
          <label for="coursecode" class="form-label">Course Code</label>
          <input type="text" class="form-control" id="coursecode" name="coursecode" placeholder="Course Code" value="{{$recordsdata->code}}">
          <input type="hidden" name="id" value="{{$recordsdata->id}}">
        </div>

        <div class="mb-3">
            <button type="submit" class="btn btn-primary">Update Course</button></form>

        </div>

        <hr>
        <h5>List Course Information</h5>
        <hr>


        <table class="table table-striped">
        <thead>
            <tr>
                <td>Bil</td>
                <td>Code</td>
                <td>Course Name</td>
                <td>Action</td>        
            </tr>
        </thead>
        <tbody>
            @foreach($records as $record)
            <tr>
                <td>{{++$count}}</td>
                <td>{{$record->code}}</td>
                <td>{{$record->name}}</td>
                <td>

                    
                    <a href="{{ url('/edit-course/'.$record->id) }}"
                       class="btn btn-success"
                       onclick="return confirm('Are you sure you want to edits this course?')">
                       Delete
                    </a>


                    <a href="{{ url('/delete-course/'.$record->id) }}"
                       class="btn btn-danger"
                       onclick="return confirm('Are you sure you want to delete this course?')">
                       Delete
                    </a>


                </td>
            </tr>
            @endforeach
        </tbody>
        </table>

    </div>
</div>


</div>
</body>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.min.js" integrity="sha384-G/EV+4j2dNv+tEPo3++6LCgdCROaejBqfUeNjuKAiuXbjrxilcCdDz6ZAVfHWe1Y" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</html>
