<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>List Users</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 50px auto;
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
        }

        .dashboard-box {
            background-color: white;
            border-radius: 12px;
            padding: 30px 20px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .dashboard-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }

        .dashboard-box i {
            font-size: 36px;
            margin-bottom: 15px;
            color: #007bff;
        }

        .dashboard-box span {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>

<div class="dashboard-container">
    <div class="dashboard-list">

@include('admin.navbar')

@if(session('deletemessage'))
    <div class="alert alert-danger">
        {{ session('deletemessage') }}
    </div>
@endif


<div class="row">
    <div class="col-xl-12">
        
        @if(session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif

        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif


        <h2>Scan QR</h2>

        <h3>1) Upload an image file</h3>
        <form method="POST" action="{{ url('qrscanupload') }}" enctype="multipart/form-data">
            @csrf
            <input type="file" name="qrimage" accept="image/*" required>
            <button type="submit">Upload & Decode</button>
        </form>

        <hr>
    
    </div>
</div>
<!-- end row -->


    </div>
</div>

</body>

<!-- html5-qrcode CDN (simple way) -->
<script src="https://unpkg.com/html5-qrcode@2.3.7/minified/html5-qrcode.min.js"></script>
<script>
const qrRegionId = "reader";
const html5QrCode = new Html5Qrcode(qrRegionId);

document.getElementById('startBtn').addEventListener('click', function(){
    Html5Qrcode.getCameras().then(cameras => {
        if (cameras && cameras.length) {
            const cameraId = cameras[0].id;
            html5QrCode.start(
                cameraId,
                { fps: 10, qrbox: 250 },
                qrCodeMessage => {
                    document.getElementById('cameraResult').innerText = "Decoded: " + qrCodeMessage;
                    // Optionally stop after first successful decode:
                    html5QrCode.stop();
                },
                errorMessage => {
                    // ignore decode errors
                })
            .catch(err => {
                console.error("Unable to start camera", err);
            });
        } else {
            alert("No camera found.");
        }
    }).catch(err => {
        alert("Error getting cameras: " + err);
    });
});

document.getElementById('stopBtn').addEventListener('click', function(){
    html5QrCode.stop().catch(e => console.warn(e));
});
</script>


<!-- apexcharts -->
<script src="{{ URL::asset('build/libs/apexcharts/apexcharts.min.js') }}"></script>

<script type="text/javascript">
    /*
Template Name: Skote - Admin & Dashboard Template
Author: Themesbrand
Website: https://themesbrand.com/
Contact: themesbrand@gmail.com
File: Dashboard Init Js File
*/

// get colors array from the string
function getChartColorsArray(chartId) {
    if (document.getElementById(chartId) !== null) {
        var colors = document.getElementById(chartId).getAttribute("data-colors");
        if (colors) {
            colors = JSON.parse(colors);
            return colors.map(function (value) {
                var newValue = value.replace(" ", "");
                if (newValue.indexOf(",") === -1) {
                    var color = getComputedStyle(document.documentElement).getPropertyValue(newValue);
                    if (color) return color;
                    else return newValue;;
                } else {
                    var val = value.split(',');
                    if (val.length == 2) {
                        var rgbaColor = getComputedStyle(document.documentElement).getPropertyValue(val[0]);
                        rgbaColor = "rgba(" + rgbaColor + "," + val[1] + ")";
                        return rgbaColor;
                    } else {
                        return newValue;
                    }
                }
            });
        }
    }
}


</script>
</html>