<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>{{ config('app.name', 'Attendance System') }}</title>

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

    <style>

        body {
    margin: 0;
    padding: 0;
    background: linear-gradient(135deg, #0d6efd, #53e3a6);
    font-family: "Poppins", sans-serif;
    height: 100vh;
    display: flex;
    justify-content: center;
    align-items: center;
}


        .login-card {
            width: 40%;
            background: rgba(255, 255, 255, 0.25);
            backdrop-filter: blur(12px);
            border-radius: 16px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            padding: 35px;
            text-align: center;
        }

        .login-card h2 {
            font-weight: 600;
            margin-bottom: 5px;
            color: #fff;
        }

        .login-card p {
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 25px;
            font-size: 14px;
        }

        .input-group {
            position: relative;
            margin-bottom: 20px;
            width: 100%;
        }

        .input-group input {
            width: 100%;
            border: none;
            outline: none;
            background: rgba(255, 255, 255, 0.85);
            padding: 14px 50px 14px 15px; /* left/right balanced */
            border-radius: 10px;
            font-size: 15px;
            box-sizing: border-box;
        }

        .input-group i {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 18px;
            color: #444;
            cursor: pointer;
        }

        .btn-login {
            width: 100%;
            background: #fff;
            border: none;
            padding: 14px;
            font-size: 16px;
            border-radius: 10px;
            cursor: pointer;
            transition: 0.3s;
            font-weight: 600;
            color: #2e8c78;
            box-sizing: border-box;
        }

        .btn-login:hover {
            background: #f3f3f3;
        }


        .error-text {
            color: #ffefef;
            background: rgba(255, 70, 70, 0.75);
            padding: 8px;
            border-radius: 8px;
            font-size: 14px;
            margin-bottom: 15px;
        }
    </style>
</head>

<body>

    <div class="login-card">

        <h2>Welcome</h2>
        <p>Attendance QR System</p>

        @if ($errors->any())
            <div class="error-text">{{ $errors->first() }}</div>
        @endif

        <form action="/login" method="POST">
            @csrf

            <!-- Username -->
            <div class="input-group">
                <input type="text" name="username" placeholder="Username / Email" required>
                <i class="bi bi-person-fill"></i>
            </div>

            <!-- Password -->
            <div class="input-group">
                <input type="password" name="password" id="password-field" placeholder="Password" required>
                <i class="bi bi-eye-fill" id="togglePassword"></i>
            </div>

            <button class="btn-login" type="submit">Login</button>
        </form>

    </div>

    <script>
        document.getElementById("togglePassword").addEventListener("click", function () {
            const input = document.getElementById("password-field");
            if (input.type === "password") {
                input.type = "text";
                this.classList.remove("bi-eye-fill");
                this.classList.add("bi-eye-slash-fill");
            } else {
                input.type = "password";
                this.classList.remove("bi-eye-slash-fill");
                this.classList.add("bi-eye-fill");
            }
        });
    </script>

</body>

</html>
