<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\AttendanceQRController;

use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\Models\AttendanceQR;
use App\Models\AttendanceRecord;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

// use Illuminate\Http\Request;
use Illuminate\Support\Str;

// For generation
// use SimpleSoftwareIO\QrCode\Facades\QrCode;

// For decoding server-side
use Zxing\QrReader; // from khanamiryan/qrcode-detector-decoder
// use Carbon\Carbon;
// use Illuminate\Support\Facades\DB;
// use Illuminate\Support\Facades\Auth;

class AttendanceQRController extends Controller
{
    // Admin generates QR for today
    public function generateDailyQR(Request $request)
    {
        $examid = $request->input('examid');
        $keyExzam = $request->input('keyExzam');
        $dataexam = DB::table('examination_details')->where('id', $examid)->first();

        $today = Carbon::today();
        $url = "http://" . $_SERVER['HTTP_HOST'];

        $qrImage = QrCode::size(280)->generate($url . '/scan-attendance/' . $keyExzam);

        return view('qr.show', compact('qrImage', 'dataexam', 'today'));
    }



    public function scanAttendance($code)
    {
        $qr = AttendanceQR::where('code', $code)
                           ->where('valid_date', Carbon::today())
                           ->first();

        if (!$qr) {
            return "Invalid or expired QR";
        }

        // Example: scanned by user with ID = 1
        $userId = 1;

        AttendanceRecord::create([
            'user_id' => $userId,
            'attendance_qr_id' => $qr->id,
            'scanned_at' => now()
        ]);

        return "Attendance Successful!";
    }

    public function adminDashboard()
    {
        $records = AttendanceRecord::with('user', 'qr')
                                   ->orderBy('scanned_at', 'DESC')
                                   ->paginate(20);

        return view('admin.attendance.index', compact('records'));
    }

    public function scanqr() {
        return view('qr.scanner');
    }

    public function scannercamera() {
        return view('qr.scanner-camera');
    }

    public function qrscanupload(Request $request) {
        $request->validate([
            'qrimage' => 'required|image|max:5120', // <= 5MB
        ]);

        $file = $request->file('qrimage');
        $storedPath = $file->store('qr_uploads', 'public'); // storage/app/public/qr_uploads/...

        // full path
        $fullPath = storage_path('app/public/' . $storedPath);

        // decode using QrReader
        try {
            $qrcode = new QrReader($fullPath);
            $text = $qrcode->text(); // returns null if not found
            return redirect()->to($text);

        } catch (\Exception $e) {
            $text = null;
            return back()->with('error', 'QR code not valid');
        }

        dd($text);

    }

    public function qrscancamera(Request $request) {

        if (!$request->userid) {
        return back()->with('error', 'QR scan failed.');
        }

        $text = $request->userid;
        // dd($text);
        return redirect()->to($text);

    }

}
