<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class AuthController extends Controller
{
    // Show login page+

    public function createuser(){

        // You can auto-generate name/email or take from request
        $name  = $request->name  ?? 'User_' . rand(1000, 9999);
        $email = $request->email ?? 'user' . rand(1000, 9999) . '@example.com';

        // Create user
        $user = User::create([
            'name'     => $name,
            'email'    => $email,
            'password' => Hash::make('12345678'),   // default password
        ]);

    }


    public function loginPage()
    {
        return view('auth.login');
    }

    // Process login
    public function login(Request $request)
    {
        $credentials = $request->validate([
            'username'    => 'required',
            'password' => 'required',
        ]);
        // dd($request);
        // dd(Auth::attempt($credentials));
        if (Auth::attempt($credentials)) {
            $request->session()->regenerate();
            return redirect('/dashboard');
        }

        return back()->withErrors([
            'email' => 'Invalid login details.',
        ]);
    }

    // Dashboard after login
    public function dashboard()
    {
        $user = Auth::user(); 
        $totalezxam = DB::table('examination_details')->count();
        $totaltudent = DB::table('users')->where('level', 3)->count();
        $totaladmin = DB::table('users')->where('level', 2)->count();
        $activeuser = DB::table('users')->whereIn('level', [3,2])->count();
        return view('admin.dashboard', compact('user', 'totalezxam', 'totaltudent', 'totaladmin', 'activeuser'));
    }

    // Logout
    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect('/');
    }
}
