<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\AttendanceQRController;

use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\Models\AttendanceQR;
use App\Models\AttendanceRecord;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ExzamController extends Controller
{
    // Admin generates QR for today
    public function create(Request $request) {

        $roles = DB::table('roles')->get();
        $courserecord = DB::table('courses')->get();

        return view('admin.createexzam', compact('roles', 'courserecord'));
    }

    public function save(Request $request) {
        // dd($request);
        $user = Auth::user(); 
        $courseid = $request->input('courseid');
        $name = $request->input('name');
        $LocationExzam = $request->input('LocationExzam');
        $startexam = $request->input('startexam');
        $starttimeexam = $request->input('starttimeexam');
        $endtimeexam = $request->input('endtimeexam');
        $createby = $user['id'];


        DB::table('examination_details')->insert([
            'courseid' => $courseid,
            'name'     => $name,
            'LocationExzam'     => $LocationExzam,
            'startexam'     => $startexam,
            'starttimeexam'     => $starttimeexam,
            'endtimeexam'     => $endtimeexam,
            'createby'     => $createby,  
            'keyExzam'     => Hash::make($name.$startexam),
        ]);

        return redirect()->back()->with('success', 'Data Examination create successfully!');

    }

    public function view(Request $request) {

        $examination_details = DB::table('examination_details')->paginate(10);
        $count = 0;
        return view('admin.viewexzam', compact('examination_details', 'count'));
    }

    

    public function record(Request $request) {

        $user = Auth::user();
        $examination_details = DB::table('attendance_records')
        ->join('examination_details', 'attendance_records.attendance_qr_id', 'examination_details.id')
        ->where('attendance_records.user_id', $user['id'])->paginate(10);
        $count = 0;
        return view('admin.record', compact('examination_details', 'count'));
    }

    public function deleteexzam($id) {

        DB::table('examination_details')->where('id', $id)->delete();
        DB::table('attendance_records')->where('attendance_qr_id', $id)->delete();

        return redirect()->back()->with('deletemessage', 'Data Examination delete successfully!');
    }


    public function updateexzam($id) {

        $examination_details = DB::table('examination_details')->where('id', $id)->first();
        $courserecord = DB::table('courses')->get();
        $count = 0;
        return view('admin.updateexzam', compact('examination_details', 'count', 'courserecord'));
    }

    
    public function saveupdateexzam(Request $request) {

        $user = Auth::user(); 
        $id = $request->input('id');
        $name = $request->input('name');
        $courseid = $request->input('courseid');
        $LocationExzam = $request->input('LocationExzam');
        $startexam = $request->input('startexam');
        $starttimeexam = $request->input('starttimeexam');
        $endtimeexam = $request->input('endtimeexam');
        $createby = $user['id'];


        DB::table('examination_details')
        ->where('id', $id)
        ->update([
            'name'     => $name,
            'courseid' => $courseid,
            'LocationExzam'     => $LocationExzam,
            'startexam'     => $startexam,
            'starttimeexam'     => $starttimeexam,
            'endtimeexam'     => $endtimeexam,
            'createby'     => $createby,  // default password
        ]);

        return redirect()->back()->with('success', 'Data Examination update successfully!');
    }

    public function generateDailyQR()
    {
        $today = Carbon::today();

        // Check existing QR for today
        $qr = AttendanceQR::where('valid_date', $today)->first();

        if (!$qr) {
            $qr = AttendanceQR::create([
                'code' => uniqid('QR-'),   // Unique QR
                'valid_date' => $today,
            ]);
        }

        $qrImage = QrCode::size(280)->generate('/scan-attendance/' . $qr->code);

        return view('qr.show', compact('qrImage', 'qr'));
    }



    public function scanAttendance($code)
    {
        $qr = AttendanceQR::where('code', $code)
                           ->where('valid_date', Carbon::today())
                           ->first();

        if (!$qr) {
            return "Invalid or expired QR";
        }

        // Example: scanned by user with ID = 1
        $userId = 1;

        AttendanceRecord::create([
            'user_id' => $userId,
            'attendance_qr_id' => $qr->id,
            'scanned_at' => now()
        ]);

        return "Attendance Successful!";
    }

    public function adminDashboard()
    {
        $records = AttendanceRecord::with('user', 'qr')
                                   ->orderBy('scanned_at', 'DESC')
                                   ->paginate(20);

        return view('admin.attendance.index', compact('records'));
    }

    public function viewcourse()
    {
        $records = DB::table('courses')->get();
        $count= 0;
        return view('admin.createcourse', compact('records','count'));
    }
    
    public function savecourse(Request $request) {

        $user = Auth::user(); 
        $name = $request->input('coursename');
        $code = $request->input('coursecode');


        DB::table('courses')
        ->insert([
            'name'     => $name,
            'code'     => $code
        ]);

        return redirect()->back()->with('success', 'Data Course successfully created!');
    }

    public function deleteCourse($id) {

        DB::table('courses')->delete($id);
        return back()->with('success', 'Data Course successfully deleted!');
    }

    public function editcourse($id) {

        $recordsdata = DB::table('courses')->where('id', $id)->first();
        $records = DB::table('courses')->get();
        $count= 0;
        return view('admin.editcourse', compact('records','count','recordsdata'));
    }

    public function saveupdatecourse(Request $request) {

        $id = $request->input('id');
        $name = $request->input('coursename');
        $code = $request->input('coursecode');

        $recordsdata = DB::table('courses')->where('id', $id)
        ->update([
            'name' => $name,
            'code' => $code
        ]);


        return back()->with('success', 'Data Course successfully update!');
    }




}
