<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 50px auto;
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
        }

        .dashboard-box {
            background-color: white;
            border-radius: 12px;
            padding: 30px 20px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .dashboard-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }

        .dashboard-box i {
            font-size: 36px;
            margin-bottom: 15px;
            color: #007bff;
        }

        .dashboard-box span {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>

@include('admin.navbar')


    <div class="mobile-toggle" id="toggleBtn">
        <i class="bi bi-list"></i>
    </div>
<div class="container">
    
    <h5>Hi, {{ $user->name }}</h5>
    <br>

    @if($user->level=='2'||$user->level=='1')
    <div class="row g-3">

        <!-- Total Examination -->
        <div class="col-6 col-md-3">
            <div class="card shadow-sm p-3 text-center" style="border-radius: 15px;">
                <i class="bi bi-journal-check" style="font-size: 2rem; color:#0d6efd;"></i>
                <h6 class="mt-2">Total Examination</h6>
                <h4 class="fw-bold">{{$totalezxam}}</h4>
            </div>
        </div>

        <!-- Total Users -->
        <div class="col-6 col-md-3">
            <div class="card shadow-sm p-3 text-center" style="border-radius: 15px;">
                <i class="bi bi-people" style="font-size: 2rem; color:#0d6efd;"></i>
                <h6 class="mt-2">Total Student</h6>
                <h4 class="fw-bold">{{$totaltudent}}</h4>
            </div>
        </div>

        <!-- Total Admin -->
        <div class="col-6 col-md-3">
            <div class="card shadow-sm p-3 text-center" style="border-radius: 15px;">
                <i class="bi bi-person-badge" style="font-size: 2rem; color:#0d6efd;"></i>
                <h6 class="mt-2">Total Teacher</h6>
                <h4 class="fw-bold">{{$totaladmin}}</h4>
            </div>
        </div>

        <!-- Total Users (Active) -->
        <div class="col-6 col-md-3">
            <div class="card shadow-sm p-3 text-center" style="border-radius: 15px;">
                <i class="bi bi-person-check" style="font-size: 2rem; color:#0d6efd;"></i>
                <h6 class="mt-2">Active Users</h6>
                <h4 class="fw-bold">{{$activeuser}}</h4>
            </div>
        </div>

    </div>
    @endif
</div>


</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
const password = document.getElementById('password');
const confirmPassword = document.getElementById('password_confirmation');
const submitBtn = document.getElementById('submitBtn');

const requirements = {
    lowercase: document.getElementById('lowercase'),
    uppercase: document.getElementById('uppercase'),
    number: document.getElementById('number'),
    symbol: document.getElementById('symbol'),
    length: document.getElementById('length'),
};

function validatePassword() {
    const val = password.value;

    // Check rules
    requirements.lowercase.style.color = /[a-z]/.test(val) ? 'green' : 'red';
    requirements.uppercase.style.color = /[A-Z]/.test(val) ? 'green' : 'red';
    requirements.number.style.color = /[0-9]/.test(val) ? 'green' : 'red';
    requirements.symbol.style.color = /[@$!%*?&#]/.test(val) ? 'green' : 'red';
    requirements.length.style.color = val.length >= 8 ? 'green' : 'red';

    // Enable submit if all green
    const allValid = Object.values(requirements).every(r => r.style.color === 'green');
    submitBtn.disabled = !allValid;
}

// Run validation on input
password.addEventListener('input', validatePassword);
confirmPassword.addEventListener('input', validatePassword);
</script>

</body>
</html>
