@php 
        $user = Auth::user();
@endphp
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.3/dist/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>

<style>
    .sidebar {
        width: 260px;
        height: 100vh;
        position: fixed;
        top: 0;
        left: 0;
        background: #0d6efd;
        color: white;
        padding-top: 20px;
        overflow-y: auto;
    }

    .sidebar a {
        padding: 12px 20px;
        display: flex;
        align-items: center;
        color: white;
        text-decoration: none;
        font-size: 15px;
        border-radius: 8px;
        margin: 5px 10px;
        transition: 0.2s;
    }

    .sidebar a:hover,
    .sidebar a.active {
        background: rgba(255,255,255,0.15);
    }

    .sidebar i {
        margin-right: 12px;
        font-size: 18px;
    }

    .content-wrapper {
        margin-left: 260px;
        padding: 20px;
    }

    /* MOBILE HIDE SIDEBAR */
    @media (max-width: 768px) {
        .sidebar {
            transform: translateX(-100%);
            transition: 0.3s ease;
            position: fixed;
            z-index: 9999;
        }

        .sidebar.open {
            transform: translateX(0);
        }

        .content-wrapper {
            margin-left: 0 !important;
        }

        .mobile-toggle {
            display: block;
        }
    }

    /* DESKTOP SHOW SIDEBAR */
    .mobile-toggle {
        display: none;
        font-size: 28px;
        margin: 10px;
        cursor: pointer;
    }



/* DESKTOP SIDEBAR */
.desktop-sidebar {
    width: 240px;
    height: 100vh;
    background: #0d6efd;
    color: white;
    padding-top: 20px;
    position: fixed;
    top: 0;
    left: 0;
}
.desktop-sidebar a {
    display: block;
    padding: 12px 20px;
    color: white;
    text-decoration: none;
}
.desktop-sidebar a.active {
    background: rgba(255, 255, 255, 0.25);
}



/* MOBILE CARD MENU – hidden by default */
.mobile-card-menu {
    display: none;
    padding: 15px;
}



/* MOBILE VIEW */
@media (max-width: 768px) {

    /* Hide desktop sidebar */
    .desktop-sidebar {
        display: none;
    }

    /* Show mobile card menu */
    .mobile-card-menu {
        display: block;
        margin-top: 10px;
    }

    /* Grid layout for cards */
    .menu-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 15px;
    }

    /* Card style */
    .menu-card {
        background: #0d6efd;
        color: white;
        padding: 18px;
        border-radius: 12px;
        text-align: center;
        text-decoration: none;
        display: flex;
        flex-direction: column;
        align-items: center;
        transition: 0.2s;
    }

    .menu-card i {
        font-size: 32px;
        margin-bottom: 8px;
    }

    .menu-card:hover {
        background: #0b5ed7;
        transform: scale(1.05);
    }
}

</style>


@php 
    $user = Auth::user();
@endphp

    
<!-- DESKTOP SIDEBAR -->
<div class="sidebar desktop-sidebar">
    <h5 class="text-center mb-4">Examination Attendance</h5>

    <a href="{{ url('dashboard') }}" class="{{ request()->is('dashboard') ? 'active' : '' }}">
        <i class="bi bi-speedometer2"></i> Dashboard
    </a>

    @if($user['level'] === '1')
    <a href="{{ url('usercreate') }}" class="{{ request()->is('usercreate') ? 'active' : '' }}">
        <i class="bi bi-person-plus"></i> Create Users
    </a>

    <a href="{{ url('listusers') }}" class="{{ request()->is('listusers') ? 'active' : '' }}">
        <i class="bi bi-people"></i> List Users
    </a>
    @endif

    @if($user['level']==='1' || $user['level']==='2')
    <a href="{{ url('create-exam') }}" class="{{ request()->is('create-exam') ? 'active' : '' }}">
        <i class="bi bi-journal-plus"></i> Create Exam Session
    </a>

    <a href="{{ url('view-exam') }}" class="{{ request()->is('view-exam') ? 'active' : '' }}">
        <i class="bi bi-card-list"></i> List Exam
    </a>

    <a href="{{ url('view-course') }}" class="menu-card">
        <i class="bi bi-book"></i>
        <span>List Course</span>
    </a>
    @endif

    <a href="{{ url('scanner-camera') }}" class="{{ request()->is('scanner-camera') ? 'active' : '' }}">
        <i class="bi bi-qr-code-scan"></i> Camera QR Code
    </a>

    <a href="{{ url('view-record') }}" class="{{ request()->is('view-record') ? 'active' : '' }}">
        <i class="bi bi-clipboard-check"></i> My Record Exam
    </a>

    <a href="{{ url('settingsprofile') }}" class="{{ request()->is('settingsprofile') ? 'active' : '' }}">
        <i class="bi bi-person-circle"></i> My Profile
    </a>

    <a href="{{ url('logout') }}">
        <i class="bi bi-box-arrow-right"></i> Log Out
    </a>
</div>



<!-- MOBILE CARD MENU -->
<div class="mobile-card-menu">

    <div class="menu-grid">

        <a href="{{ url('dashboard') }}" class="menu-card">
            <i class="bi bi-speedometer2"></i>
            <span>Dashboard</span>
        </a>

        @if($user['level'] === '1')
        <a href="{{ url('usercreate') }}" class="menu-card">
            <i class="bi bi-person-plus"></i>
            <span>Create Users</span>
        </a>

        <a href="{{ url('listusers') }}" class="menu-card">
            <i class="bi bi-people"></i>
            <span>List Users</span>
        </a>
        @endif

        @if($user['level']==='1' || $user['level']==='2')
        <a href="{{ url('create-exam') }}" class="menu-card">
            <i class="bi bi-journal-plus"></i>
            <span>Create Exam</span>
        </a>

        <a href="{{ url('view-exam') }}" class="menu-card">
            <i class="bi bi-card-list"></i>
            <span>List Exam</span>
        </a>
        @endif

        <a href="{{ url('scanner-camera') }}" class="menu-card">
            <i class="bi bi-qr-code-scan"></i>
            <span>Camera QR</span>
        </a>

        <a href="{{ url('view-record') }}" class="menu-card">
            <i class="bi bi-clipboard-check"></i>
            <span>My Record</span>
        </a>

        <a href="{{ url('settingsprofile') }}" class="menu-card">
            <i class="bi bi-person-circle"></i>
            <span>My Profile</span>
        </a>

        <a href="{{ url('logout') }}" class="menu-card">
            <i class="bi bi-box-arrow-right"></i>
            <span>Log Out</span>
        </a>

    </div>

</div>


<div class="content-wrapper">




<br><br>

@if($user['created_at']==$user['updated_at']&&$user['id']!=1) 

<hr>
<div class="dashboard-container">
    <div class="dashboard-list">
<form action="{{ url('updatePassword') }}" method="POST" id="passwordForm">
    @csrf

<div class="mb-3">
  <label for="dataInput" class="form-label">Password</label>
    <input type="hidden" class="form-control" id="userid" name="userid" value="{{$user['id']}}">
    <input type="password" class="form-control" id="password" name="password" placeholder="Password" value="">
</div>


<div class="mb-3">
  <label for="dataInput" class="form-label">Confirm Password</label>
  <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Confirm Password" value="">
</div>

    <div class="mb-3">
        <ul id="requirements" style="color:red">
        <li id="lowercase">At least one lowercase letter</li>
        <li id="uppercase">At least one uppercase letter</li>
        <li id="number">At least one number</li>
        <li id="symbol">At least one special character (@$!%*?&#)</li>
        <li id="length">Minimum 8 characters</li>
        </ul>
    </div>

    

    <button class="btn btn-primary" type="submit" id="submitBtn" disabled>Update Password</button>
</form>
    </div>
</div>



@endif

<script>
    const toggleBtn = document.getElementById('toggleBtn');
    const sidebar = document.querySelector('.sidebar');

    toggleBtn.addEventListener('click', function() {
        sidebar.classList.toggle('open');
    });
</script>

<script>
    const toggleCloseBtn = document.getElementById('toggleCloseBtn');
    const sidebar = document.querySelector('.sidebar');

    toggleCloseBtn.addEventListener('click', function() {
        sidebar.classList.toggle('close');
    });
</script>
