<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Examination</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 50px auto;
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
        }

        .dashboard-box {
            background-color: white;
            border-radius: 12px;
            padding: 30px 20px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .dashboard-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }

        .dashboard-box i {
            font-size: 36px;
            margin-bottom: 15px;
            color: #007bff;
        }

        .dashboard-box span {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>

@include('admin.navbar')

@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

<form action="{{url('saveupdateexzam')}}" method="POST">@csrf

<div class="dashboard-container">
    <div class="dashboard-list">

<hr>
<h5>Update New Examination Information</h5>
<hr>


<div class="mb-3">
  <label for="name" class="form-label">Examination Name</label>
  <input type="hidden" name="id" value="{{$examination_details->id}}">
  <input type="text" class="form-control" id="name" name="name" value="{{$examination_details->name}}" placeholder="Examination Name">
</div>
<div class="mb-3">
  <label for="courseid" class="form-label">Course Name</label>
    <select class="form-select" aria-label="Select Course" name="courseid">
        <option value="0">-- Select Course --</option>

        @foreach ($courserecord as $course)
            <option value="{{ $course->id }}"
                {{ isset($examination_details) && $examination_details->courseid == $course->id ? 'selected' : '' }}>
                {{ $course->name }} - ({{ $course->code }})
            </option>
        @endforeach
    </select>

</div>
<div class="mb-3">
  <label for="LocationExzam" class="form-label">Location Examination</label>
  <input type="text" class="form-control" id="LocationExzam" name="LocationExzam" value="{{$examination_details->LocationExzam}}" placeholder="Location Examination">
</div>
<div class="mb-3">
  <label for="startexam" class="form-label">Start Examination</label>
  <input type="date" class="form-control" id="startexam" name="startexam" value="{{$examination_details->startexam}}" placeholder="">
</div>
<div class="mb-3">
  <label for="starttimeexam" class="form-label">Start Time Examination</label>
  <input type="time" class="form-control" id="starttimeexam" name="starttimeexam" value="{{$examination_details->starttimeexam}}" placeholder="">
</div>
<div class="mb-3">
  <label for="endtimeexam" class="form-label">End Time Examination</label>
  <input type="time" class="form-control" id="endtimeexam" name="endtimeexam" value="{{$examination_details->endtimeexam}}" placeholder="">
</div>


<div class="mb-3">
    <button type="submit" class="btn btn-primary">Save Update Examination</button></form>

</div>

    </div>
</div>


</div>
</body>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.min.js" integrity="sha384-G/EV+4j2dNv+tEPo3++6LCgdCROaejBqfUeNjuKAiuXbjrxilcCdDz6ZAVfHWe1Y" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</html>
