<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit My Profile</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 50px auto;
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
        }

        .dashboard-box {
            background-color: white;
            border-radius: 12px;
            padding: 30px 20px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .dashboard-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }

        .dashboard-box i {
            font-size: 36px;
            margin-bottom: 15px;
            color: #007bff;
        }

        .dashboard-box span {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>

@include('admin.navbar')

@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

<form action="{{url('updatesaveusers')}}" method="POST">@csrf

<div class="dashboard-container">
    <div class="dashboard-list">




<div class="mb-3">
  <label for="fullname" class="form-label">Full Name</label>
  <input type="hidden" class="form-control" id="userid" name="userid" value="{{$datausers->id}}">
  <input type="text" class="form-control" id="fullname" name="fullname" placeholder="Full Name" value="{{$datausers->name}}">
</div>
<div class="mb-3">
  <label for="email" class="form-label">Email</label>
  <input type="email" class="form-control" id="email" name="email" placeholder="name@example.com" value="{{$datausers->email}}">
</div>
<div class="mb-3">
  <label for="username" class="form-label">Username / ID Students</label>
  <input type="text" class="form-control" id="username" name="username" placeholder="" value="{{$datausers->username}}">
</div>
@php 
    $user = Auth::user();
@endphp

@if($user['id']=='1')
<div class="mb-3">
  <label for="roles" class="form-label">Roles</label>
   <select class="form-select" aria-label="Default select example" name="roles">
      <option value="0"> -- Select Roles -- </option>
      @foreach($roles as $rolesdata)
          @if($datausers->level==$rolesdata->id)
          <option value="{{$rolesdata->id}}" selected>{{$rolesdata->levelname}}</option>
          @else
          <option value="{{$rolesdata->id}}">{{$rolesdata->levelname}}</option>
          @endif
      @endforeach
    </select>
</div>
@endif



<hr>
<h5>Add Course</h5>
<hr>

<div class="row">

    @for($i = 1; $i <= 5; $i++)
    <div class="col-md-6 mb-3">
        <label class="form-label">Course {{ $i }}</label>

        <select class="form-select" name="course{{ $i }}">
            <option value="0"> -- Select Course -- </option>

            @foreach($courserecord as $course)
                <option value="{{ $course->id }}"
                    {{ old('course'.$i, $datacourse->{'course'.$i} ?? 0) == $course->id ? 'selected' : '' }}>
                    {{ $course->name }} - ({{ $course->code }})
                </option>
            @endforeach

        </select>
    </div>
    @endfor

</div>


<br>

<div class="mb-3">
    <button type="submit" class="btn btn-primary">Save</button></form>

</div>

    </div>
</div>

<hr>
<div class="dashboard-container">
    <div class="dashboard-list">
<form action="{{ url('updatePassword') }}" method="POST" id="passwordForm">
    @csrf

<div class="mb-3">
  <label for="dataInput" class="form-label">Password</label>
    <input type="hidden" class="form-control" id="userid" name="userid" value="{{$datausers->id}}">
    <input type="password" class="form-control" id="password" name="password" placeholder="Password" value="">
</div>


<div class="mb-3">
  <label for="dataInput" class="form-label">Confirm Password</label>
  <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Confirm Password" value="">
</div>

    <div class="mb-3">
        <ul id="requirements" style="color:red">
        <li id="lowercase">At least one lowercase letter</li>
        <li id="uppercase">At least one uppercase letter</li>
        <li id="number">At least one number</li>
        <li id="symbol">At least one special character (@$!%*?&#)</li>
        <li id="length">Minimum 8 characters</li>
        </ul>
    </div>

    

    <button class="btn btn-primary" type="submit" id="submitBtn" disabled>Update Password</button>
</form>
    </div>
</div>



</div>
</body>
<script>
const password = document.getElementById('password');
const confirmPassword = document.getElementById('password_confirmation');
const submitBtn = document.getElementById('submitBtn');

const requirements = {
    lowercase: document.getElementById('lowercase'),
    uppercase: document.getElementById('uppercase'),
    number: document.getElementById('number'),
    symbol: document.getElementById('symbol'),
    length: document.getElementById('length'),
};

function validatePassword() {
    const val = password.value;

    // Check rules
    requirements.lowercase.style.color = /[a-z]/.test(val) ? 'green' : 'red';
    requirements.uppercase.style.color = /[A-Z]/.test(val) ? 'green' : 'red';
    requirements.number.style.color = /[0-9]/.test(val) ? 'green' : 'red';
    requirements.symbol.style.color = /[@$!%*?&#]/.test(val) ? 'green' : 'red';
    requirements.length.style.color = val.length >= 8 ? 'green' : 'red';

    // Enable submit if all green
    const allValid = Object.values(requirements).every(r => r.style.color === 'green');
    submitBtn.disabled = !allValid;
}

// Run validation on input
password.addEventListener('input', validatePassword);
confirmPassword.addEventListener('input', validatePassword);
</script>


<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.min.js" integrity="sha384-G/EV+4j2dNv+tEPo3++6LCgdCROaejBqfUeNjuKAiuXbjrxilcCdDz6ZAVfHWe1Y" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</html>
