<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>List Users</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 50px auto;
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
        }

        .dashboard-box {
            background-color: white;
            border-radius: 12px;
            padding: 30px 20px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .dashboard-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }

        .dashboard-box i {
            font-size: 36px;
            margin-bottom: 15px;
            color: #007bff;
        }

        .dashboard-box span {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>

@include('admin.navbar')

@if(session('deletemessage'))
    <div class="alert alert-danger">
        {{ session('deletemessage') }}
    </div>
@endif


<div class="dashboard-container">
    <div class="dashboard-list">


<table class="table table-striped">
<thead>
    <tr>
        <td>Bil</td>
        <td>Examination Name</td>
        <td>Location</td>
        <td>Date Duration</td>
        <td>Total Attendance</td>     
        <td>Action</td>        
    </tr>
</thead>
<tbody>
    @foreach($examination_details as $examination_detailss)
    @php 
     $totalattends = 0;
     
     $totalattends = DB::table('attendance_records')
        ->join('examination_details', 'attendance_records.attendance_qr_id', 'examination_details.id')
        ->where('attendance_records.attendance_qr_id', $examination_detailss->id)
        ->count();

    @endphp
    <tr>
        <td>{{++$count}}</td>
        <td>{{$examination_detailss->name}}</td>
        <td>{{$examination_detailss->LocationExzam}}</td>
        <td>Date : {{$examination_detailss->startexam}}
            <br>Start Time : {{$examination_detailss->starttimeexam}}
            <br>End Time : {{$examination_detailss->endtimeexam}}
        </td>
        <td>{{$totalattends}}</td>
        <td>
            <table>
                <tr>
                    <td><button class="btn btn-primary" onclick="confirmViews({{$examination_detailss->id}})">View Records</button></td>
                    <td><button class="btn btn-primary" onclick="confirmEdits({{$examination_detailss->id}})">Edits</button></td>
                    <td><button class="btn btn-danger" onclick="confirmDelete({{$examination_detailss->id}})">Delete</button></td>
                    <td><form action="{{url('qr')}}" method="POST" target="_blank">@csrf
                        <input type="hidden" name="examid" value="{{$examination_detailss->id}}">
                        <input type="hidden" name="keyExzam" value="{{$examination_detailss->keyExzam}}">
                        <button type="submit" class="btn btn-success">QR Code</button>
                        </form></td>
                </tr>
            </table>
        </td>
    </tr>
    @endforeach
</tbody>
</table>

    {{ $examination_details->links() }}
    </div>
</div>


</div>

</body>


<script>
function confirmDelete(x) {
    if (confirm("Are you sure you want to delete this user?")) {
        // Redirect to delete URL
        window.location.href = "/deleteexzam/"+x;
    }
}

function confirmEdits(x) {
    if (confirm("Are you sure you want to edits this user?")) {
        // Redirect to delete URL
        window.location.href = "/editsexzam/"+x;
    }
}

function confirmViews(x) {
    if (confirm("Are you sure you want to view record attendance ?")) {
        // Redirect to delete URL
        window.location.href = "/viewrecordattendance/"+x;
    }
}


</script>


<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.min.js" integrity="sha384-G/EV+4j2dNv+tEPo3++6LCgdCROaejBqfUeNjuKAiuXbjrxilcCdDz6ZAVfHWe1Y" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</html>
