<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AttendanceQRController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\UserAutoController;
use App\Http\Controllers\AuthController;



Route::get('/', function () {
    return view('welcome');
});


Route::get('/createuser', [AuthController::class, 'createuser']);
Route::get('/login', [AuthController::class, 'loginPage'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/dashboard', [AuthController::class, 'dashboard'])->middleware('auth');
Route::get('/logout', [AuthController::class, 'logout'])->middleware('auth');



Route::get('/usercreate', [UserAutoController::class, 'create']);
Route::post('/saveusers', [UserAutoController::class, 'save']);
Route::get('/listusers', [UserAutoController::class, 'view']);;
Route::get('/deleteusers/{id}', [UserAutoController::class, 'delete']);
Route::get('/editusers/{id}', [UserAutoController::class, 'editusers']);

Route::get('/settingsprofile', [UserAutoController::class, 'settingsprofile']);
Route::post('/updatesaveusers', [UserAutoController::class, 'updatesaveusers']);
Route::post('/updatePassword', [UserAutoController::class, 'updatePassword']);

Route::get('/generate-qr', [AttendanceController::class, 'generate']);
Route::get('/scan-attendance/{id}', [AttendanceController::class, 'scan']);
Route::get('/viewrecordattendance/{id}', [AttendanceController::class, 'viewrecordattendance']);
Route::post('/qr', [AttendanceQRController::class, 'generateDailyQR']);


Route::get('/admin/attendance', [AttendanceQRController::class, 'adminDashboard']);
Route::get('/scanqr-record', [AttendanceQRController::class, 'scanqr']);
Route::post('/qrscanupload', [AttendanceQRController::class, 'qrscanupload']);
Route::post('/qrscancamera', [AttendanceQRController::class, 'qrscancamera']);
Route::get('/scanner-camera', [AttendanceQRController::class, 'scannercamera']);


Route::get('view-record', [App\Http\Controllers\ExzamController::class, 'record']);

Route::get('create-exam', [App\Http\Controllers\ExzamController::class, 'create']);
Route::post('save-exam', [App\Http\Controllers\ExzamController::class, 'save']);
Route::get('view-exam', [App\Http\Controllers\ExzamController::class, 'view']);
Route::post('update-exam', [App\Http\Controllers\ExzamController::class, 'update']);

Route::get('deleteexzam/{id}', [App\Http\Controllers\ExzamController::class, 'deleteexzam']);
Route::get('editsexzam/{id}', [App\Http\Controllers\ExzamController::class, 'updateexzam']);
Route::post('saveupdateexzam', [App\Http\Controllers\ExzamController::class, 'saveupdateexzam']);


Route::get('view-course', [App\Http\Controllers\ExzamController::class, 'viewcourse']);
Route::post('save-course', [App\Http\Controllers\ExzamController::class, 'savecourse']);
Route::get('delete-course/{id}', [App\Http\Controllers\ExzamController::class, 'deleteCourse']);
Route::get('edit-course/{id}', [App\Http\Controllers\ExzamController::class, 'editcourse']);
Route::post('saveupdate-course', [App\Http\Controllers\ExzamController::class, 'saveupdatecourse']);

Route::get('/scanner', function () {
    return view('scanner');
});
