<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit My Profile</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 50px auto;
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
        }

        .dashboard-box {
            background-color: white;
            border-radius: 12px;
            padding: 30px 20px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .dashboard-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }

        .dashboard-box i {
            font-size: 36px;
            margin-bottom: 15px;
            color: #007bff;
        }

        .dashboard-box span {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>

<?php echo $__env->make('admin.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>

<form action="<?php echo e(url('updatesaveusers')); ?>" method="POST"><?php echo csrf_field(); ?>

<div class="dashboard-container">
    <div class="dashboard-list">




<div class="mb-3">
  <label for="fullname" class="form-label">Full Name</label>
  <input type="hidden" class="form-control" id="userid" name="userid" value="<?php echo e($datausers->id); ?>">
  <input type="text" class="form-control" id="fullname" name="fullname" placeholder="Full Name" value="<?php echo e($datausers->name); ?>">
</div>
<div class="mb-3">
  <label for="email" class="form-label">Email</label>
  <input type="email" class="form-control" id="email" name="email" placeholder="name@example.com" value="<?php echo e($datausers->email); ?>">
</div>
<div class="mb-3">
  <label for="username" class="form-label">Username / ID Students</label>
  <input type="text" class="form-control" id="username" name="username" placeholder="" value="<?php echo e($datausers->username); ?>">
</div>
<?php 
    $user = Auth::user();
?>

<?php if($user['id']=='1'): ?>
<div class="mb-3">
  <label for="roles" class="form-label">Roles</label>
   <select class="form-select" aria-label="Default select example" name="roles">
      <option value="0"> -- Select Roles -- </option>
      <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rolesdata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php if($datausers->level==$rolesdata->id): ?>
          <option value="<?php echo e($rolesdata->id); ?>" selected><?php echo e($rolesdata->levelname); ?></option>
          <?php else: ?>
          <option value="<?php echo e($rolesdata->id); ?>"><?php echo e($rolesdata->levelname); ?></option>
          <?php endif; ?>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>
<?php endif; ?>



<hr>
<h5>Add Course</h5>
<hr>

<div class="row">

    <?php for($i = 1; $i <= 5; $i++): ?>
    <div class="col-md-6 mb-3">
        <label class="form-label">Course <?php echo e($i); ?></label>

        <select class="form-select" name="course<?php echo e($i); ?>">
            <option value="0"> -- Select Course -- </option>

            <?php $__currentLoopData = $courserecord; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($course->id); ?>"
                    <?php echo e(old('course'.$i, $datacourse->{'course'.$i} ?? 0) == $course->id ? 'selected' : ''); ?>>
                    <?php echo e($course->name); ?> - (<?php echo e($course->code); ?>)
                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </select>
    </div>
    <?php endfor; ?>

</div>


<br>

<div class="mb-3">
    <button type="submit" class="btn btn-primary">Save</button></form>

</div>

    </div>
</div>

<hr>
<div class="dashboard-container">
    <div class="dashboard-list">
<form action="<?php echo e(url('updatePassword')); ?>" method="POST" id="passwordForm">
    <?php echo csrf_field(); ?>

<div class="mb-3">
  <label for="dataInput" class="form-label">Password</label>
    <input type="hidden" class="form-control" id="userid" name="userid" value="<?php echo e($datausers->id); ?>">
    <input type="password" class="form-control" id="password" name="password" placeholder="Password" value="">
</div>


<div class="mb-3">
  <label for="dataInput" class="form-label">Confirm Password</label>
  <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Confirm Password" value="">
</div>

    <div class="mb-3">
        <ul id="requirements" style="color:red">
        <li id="lowercase">At least one lowercase letter</li>
        <li id="uppercase">At least one uppercase letter</li>
        <li id="number">At least one number</li>
        <li id="symbol">At least one special character (@$!%*?&#)</li>
        <li id="length">Minimum 8 characters</li>
        </ul>
    </div>

    

    <button class="btn btn-primary" type="submit" id="submitBtn" disabled>Update Password</button>
</form>
    </div>
</div>



</div>
</body>
<script>
const password = document.getElementById('password');
const confirmPassword = document.getElementById('password_confirmation');
const submitBtn = document.getElementById('submitBtn');

const requirements = {
    lowercase: document.getElementById('lowercase'),
    uppercase: document.getElementById('uppercase'),
    number: document.getElementById('number'),
    symbol: document.getElementById('symbol'),
    length: document.getElementById('length'),
};

function validatePassword() {
    const val = password.value;

    // Check rules
    requirements.lowercase.style.color = /[a-z]/.test(val) ? 'green' : 'red';
    requirements.uppercase.style.color = /[A-Z]/.test(val) ? 'green' : 'red';
    requirements.number.style.color = /[0-9]/.test(val) ? 'green' : 'red';
    requirements.symbol.style.color = /[@$!%*?&#]/.test(val) ? 'green' : 'red';
    requirements.length.style.color = val.length >= 8 ? 'green' : 'red';

    // Enable submit if all green
    const allValid = Object.values(requirements).every(r => r.style.color === 'green');
    submitBtn.disabled = !allValid;
}

// Run validation on input
password.addEventListener('input', validatePassword);
confirmPassword.addEventListener('input', validatePassword);
</script>


<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.min.js" integrity="sha384-G/EV+4j2dNv+tEPo3++6LCgdCROaejBqfUeNjuKAiuXbjrxilcCdDz6ZAVfHWe1Y" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</html>
<?php /**PATH C:\xampp\htdocs\attendQR\resources\views/admin/updateuser.blade.php ENDPATH**/ ?>