<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>List Users</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 50px auto;
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
        }

        .dashboard-box {
            background-color: white;
            border-radius: 12px;
            padding: 30px 20px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .dashboard-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }

        .dashboard-box i {
            font-size: 36px;
            margin-bottom: 15px;
            color: #007bff;
        }

        .dashboard-box span {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>

<?php echo $__env->make('admin.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php if(session('deletemessage')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('deletemessage')); ?>

    </div>
<?php endif; ?>


<div class="dashboard-container">
    <div class="dashboard-list">


<table class="table table-striped">
<thead>
    <tr>
        <td>Bil</td>
        <td>Name</td>
        <td>Username</td>
        <td>Email</td>
        <td>Roles</td>
        <td>Action</td>        
    </tr>
</thead>
<tbody>
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usersdata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php 
     $usersroles = '';
     $dataroles = DB::table('roles')->where('id', $usersdata->level)->first();
     $usersroles = $dataroles->levelname ?? '';
    ?>
    <tr>
        <td><?php echo e(++$count); ?></td>
        <td><?php echo e($usersdata->name); ?></td>
        <td><?php echo e($usersdata->username); ?></td>
        <td><?php echo e($usersdata->email); ?></td>
        <td><?php echo e($usersroles); ?></td>
        <td>
            <button class="btn btn-primary" onclick="confirmEdits(<?php echo e($usersdata->id); ?>)">Edits</button>
            <button class="btn btn-danger" onclick="confirmDelete(<?php echo e($usersdata->id); ?>)">Delete</button>

        </td>
    </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tbody>
</table>

    <?php echo e($users->links()); ?>

    </div>
</div>


</div>
</body>


<script>
function confirmDelete(x) {
    if (confirm("Are you sure you want to delete this user?")) {
        // Redirect to delete URL
        window.location.href = "/deleteusers/"+x;
    }
}

function confirmEdits(x) {
    if (confirm("Are you sure you want to edits this user?")) {
        // Redirect to delete URL
        window.location.href = "/editusers/"+x;
    }
}


</script>


<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.min.js" integrity="sha384-G/EV+4j2dNv+tEPo3++6LCgdCROaejBqfUeNjuKAiuXbjrxilcCdDz6ZAVfHWe1Y" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</html>
<?php /**PATH C:\xampp\htdocs\attendQR\resources\views/admin/listusers.blade.php ENDPATH**/ ?>