<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>List Users</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 50px auto;
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 20px;
        }

        .dashboard-box {
            background-color: white;
            border-radius: 12px;
            padding: 30px 20px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .dashboard-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }

        .dashboard-box i {
            font-size: 36px;
            margin-bottom: 15px;
            color: #007bff;
        }

        .dashboard-box span {
            display: block;
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
    </style>
        <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
</head>
<body>

<div class="dashboard-container">
    <div class="dashboard-list">

<?php echo $__env->make('admin.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php if(session('deletemessage')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('deletemessage')); ?>

    </div>
<?php endif; ?>


<div class="row">
    <div class="col-xl-12">
        
        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>


        <h2>Scan QR</h2>

       <div id="reader" style="width: 300px;"></div>

        <form id="qrForm" method="POST" action="<?php echo e(url('qrscancamera')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="userid" id="qr_text">
        </form>

    
    </div>
</div>
<!-- end row -->


    </div>
</div>

<script>
    const html5QrCode = new Html5Qrcode("reader");

    function onScanSuccess(decodedText, decodedResult) {
        console.log("QR Detected: " + decodedText);

        // Put scanned text into hidden field
        document.getElementById('qr_text').value = decodedText;

        // 🛑 Stop the camera IMMEDIATELY after first scan
        html5QrCode.stop().then(() => {
            console.log("Camera stopped");

            // Submit form
            document.getElementById('qrForm').submit();
        }).catch(err => {
            console.log("Error stopping camera: " + err);
        });
    }

    // Start camera
    Html5Qrcode.getCameras().then(devices => {
        if (devices && devices.length) {
            let cameraId = devices[0].id;
            html5QrCode.start(
                cameraId,
                {
                    fps: 10,
                    qrbox: 200
                },
                onScanSuccess
            );
        }
    }).catch(err => console.error(err));
</script>

</script>
<!-- dashboard init -->
<script src="<?php echo e(URL::asset('build/js/pages/dashboard.init.js')); ?>"></script>
</body>
</html><?php /**PATH C:\xampp\htdocs\attendQR\resources\views/qr/scanner-camera.blade.php ENDPATH**/ ?>