<?php

namespace App\Http\Controllers;

use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Http\Request;
use App\Models\Attendance;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\AttendanceQRController;
use QrReader;
use Carbon\Carbon;

class AttendanceController extends Controller
{
    public function viewrecordattendance($examid)
    {

        $datarecord = DB::table('attendance_records')
        ->join('users', 'attendance_records.user_id', 'users.id')
        ->where('attendance_records.attendance_qr_id', $examid)
        ->paginate(10);
        $bil=0;
        return view('admin.viewrecordattendance', compact('datarecord', 'bil'));
    }

    public function scan($examid, $time)
    {        
        $countenroll=0;
        $user = Auth::user(); 
        date_default_timezone_set('Asia/Kuala_Lumpur');

        ///check time checin in time 
        $qrtime = $time;
        $currenttime = time();

        $qrtime = $time;        // masa QR dijana (timestamp)
        $currenttime = time(); // masa sekarang (timestamp)

        if (($currenttime - $qrtime) > 30) {
            
            return redirect()->back()->with('error', 'QR code has expired. Please generate a new QR.');
        }


        $dataexam = DB::table('examination_details')->where('keyExzam', $examid)->first();

        //check enroll to course or not
        $datacourse_assign = DB::table('course_assign')->where('userid', $user['id'])->first();
        if($datacourse_assign->course1==$dataexam->courseid){ ++$countenroll; }
        if($datacourse_assign->course2==$dataexam->courseid){ ++$countenroll; }
        if($datacourse_assign->course3==$dataexam->courseid){ ++$countenroll; }
        if($datacourse_assign->course4==$dataexam->courseid){ ++$countenroll; }
        if($datacourse_assign->course5==$dataexam->courseid){ ++$countenroll; }

        if($countenroll==0)
        {            
        return redirect()->back()->with('error', 'Attendance Recorded FAILED, You not enroll to this course.');
        }
        
        $datatimestart = $dataexam->startexam.' '.$dataexam->starttimeexam;
        $timestampstart = Carbon::parse($datatimestart)->timestamp;

        $datatimeend = $dataexam->startexam.' '.$dataexam->endtimeexam;
        $timestampend = Carbon::parse($datatimeend)->timestamp;


        $currenttime = time();

        $dataexamcount = DB::table('attendance_records')
        ->where('user_id', $user['id'])
        ->where('attendance_qr_id', $examid)
        ->count();
        
        if($dataexamcount==1) {

            return redirect()->back()->with('error', 'Attendance Recorded FAILED, You already check In.');
        }

        if($currenttime>=$timestampstart&&$currenttime<=$timestampend) {

            DB::table('attendance_records')->insert([
                'user_id' => $user['id'],
                'attendance_qr_id' => $dataexam->id,
                'scanned_at' => now(),
                'created_at' => now(),
                'updated_at' => now()
            ]);
            
            return redirect()->back()->with('success', 'Attendance Recorded for User ID');
        }else {

            return back()->with('error', 'Attendance failed. Please check in within the exam start and end time.  (' . $dataexam->startexam.' '.$dataexam->starttimeexam . ' hingga ' . $dataexam->startexam.' '.$dataexam->endtimeexam . ').');

        }

        // return "Attendance Recorded for User ID: $userId";
    }
}
