<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;



class UserAutoController extends Controller
{
    // Auto generate user account
    public function create()
    {
        $roles = DB::table('roles')->get();
        $courserecord = DB::table('courses')->get();
        return view('admin.createuser', compact('roles', 'courserecord'));
    }

    public function save(Request $request) {

        $fullname = $request->input('fullname');
        $email = $request->input('email');
        $roles = $request->input('roles');
        $username = $request->input('username');

        // Create user
        $user = User::create([
            'username'     => $username,
            'name'     => $fullname,
            'email'    => $email,
            'level'    => $roles,
            'password' => Hash::make($username),   // default password
        ]);


        $course1 = $request->input('course1');
        $course2 = $request->input('course2');
        $course3 = $request->input('course3');
        $course4 = $request->input('course4');
        $course5 = $request->input('course5');

        // Create course
        DB::table('course_assign')->insert([
            'userid'     => $user->id,
            'course1'    => $course1,
            'course2'    => $course2,
            'course3'    => $course3,
            'course4'    => $course4,
            'course5'    => $course5  // default password
        ]);

        return redirect()->back()->with('success', 'Data users create successfully!');

    }


    public function view()
    {
        $users = DB::table('users')->paginate(10);
        $count=0;
        return view('admin.listusers', compact('users', 'count'));
    }

    public function delete($id) {

        DB::table('users')->where('id', $id)->delete();
        DB::table('course_assign')->where('userid', $id)->delete();

        return redirect()->back()->with('deletemessage', 'Data users delete successfully!');
    }

    public function settingsprofile() {

        $user = Auth::user(); // returns the logged-in user object
        $datausers = DB::table('users')->where('id', $user['id'])->first();
        $roles = DB::table('roles')->get();
        $courserecord = DB::table('courses')->get();
        $datacourse = DB::table('course_assign')->where('userid', $user['id'])->first();

        return view('admin.updateuser', compact('roles', 'datausers', 'courserecord', 'datacourse'));
    }

    public function editusers($id) {

        $datausers = DB::table('users')->where('id', $id)->first();
        $roles = DB::table('roles')->get();
        $courserecord = DB::table('courses')->get();
        $datacourse = DB::table('course_assign')->where('userid', $id)->first();

        return view('admin.updateuser', compact('roles', 'datausers', 'courserecord', 'datacourse'));
    }

    public function updatesaveusers(Request $request) {

            // dd($request);
        $userdata = Auth::user();
        $userid = $request->input('userid');
        $fullname = $request->input('fullname');
        $email = $request->input('email');
        $roles = $request->input('roles');
        $username = $request->input('username');

        $user = User::find($userid);

        if ($user) {

            if(!empty($username ?? '')){

                DB::table('users')
                    ->where('id', $userid)
                    ->update([
                        'username'    => $username
                    ]);
            }


            if(!empty($fullname ?? '')){
                
                DB::table('users')
                    ->where('id', $userid)
                    ->update([
                        'name'    => $fullname
                    ]);
            }


            if(!empty($fullname ?? '')){
                
                DB::table('users')
                    ->where('id', $userid)
                    ->update([
                        'name'    => $fullname
                    ]);
            }



            if(!empty($email ?? '')){
                
                DB::table('users')
                    ->where('id', $userid)
                    ->update([
                        'email'    => $email
                    ]);
            }
            

            if($userdata['level']!=3) {
                $course1 = $request->input('course1');
                $course2 = $request->input('course2');
                $course3 = $request->input('course3');
                $course4 = $request->input('course4');
                $course5 = $request->input('course5');

                $datacount = DB::table('course_assign')
                ->where('userid', $userid)
                ->count();

                if($datacount==0) {

                    DB::table('course_assign')->insert([
                        'userid'     => $userid,
                        'course1'    => $course1,
                        'course2'    => $course2,
                        'course3'    => $course3,
                        'course4'    => $course4,
                        'course5'    => $course5  // default password
                    ]);

                }else {

                    // Create course
                    DB::table('course_assign')
                    ->where('userid', $userid)
                    ->update([
                        'course1'    => $course1,
                        'course2'    => $course2,
                        'course3'    => $course3,
                        'course4'    => $course4,
                        'course5'    => $course5  // default password
                    ]);

                }
            }

            return back()->with('success', 'User updated successfully!');
        } else {
            return back()->with('error', 'User not found!');
        }
    }

    public function updatePassword(Request $request) {

        $userid = $request->input('userid');
        $password = $request->input('password');

        $user = User::find($userid);

        if ($user) {         // or 'userlevel' depending on your DB
            $user->password = Hash::make($password); // only if you really want to reset
            $user->save();

            return back()->with('success', 'User updated password successfully!');
        } else {
            return back()->with('error', 'User not found!');
        }
    }

    // updatePassword
}
